k6 v0.38.2 is a patch release containing a couple of bugfixes!

### Threshold over sub-metrics without samples would result in `NaN` ([#2520](https://github.com/grafana/k6/issues/2520))

There was a bug in thresholds applied to sub-metrics set to `abortOnFail`: leading k6 to evaluate thresholds that would have likely aborted before they had a chance of passing (because no samples for the given metric were recorded yet). This bug would have led to such thresholds' results value to be `NaN` rather than a numerical value. The following script, for instance:

```javascript
import { check, sleep } from 'k6';

import http from 'k6/http';

export const options = {
  scenarios: {
    iWillFail: {
      exec: 'iWillFail',
      executor: 'constant-vus',
      startTime: '2s',
      vus: 1,
      duration: '30s',
    },
  },

  thresholds: {
    'checks{type:read}': [{ threshold: 'rate>0.9', abortOnFail: true }],
  },
};

export function iWillFail() {
  let res = http.get(`https://test-api.k6.io/`);

  check(res, {
    'read status is 200': (r) => r.status === 200,
  }, { type: 'read' });

  sleep(1);
}
```


Would result in the following:

```
✗ { type:read }...: NaN% ✓ 0 ✗ 0  
vus...............: 0 min=0 max=0
vus_max...........: 1 min=1 max=1
```

This issue was introduced by recent changes to how we handle thresholds in the k6 engine and is now addressed in `v0.38.2`.

### Sub-metrics without values rendered below an incorrect parent metric ([#2518](https://github.com/grafana/k6/issues/2518))

There was in how thresholds over sub-metrics that didn't receive any samples would be displayed under an incorrect parent metric. For instance, the following script:

```javascript
import { Counter } from 'k6/metrics';

const counter1 = new Counter("one");
const counter2 = new Counter("two");

export const options = {
    thresholds: {
        'one{tag:xyz}': [],
    },
};

export default function() {
    console.log('not submitting metric1');
    counter2.add(42);
}
```

Would have led to the following output, where the {tag:xyz} sub-metric is displayed under `iterations` instead of `one`:

```
data_received........: 0 B 0 B/s
data_sent............: 0 B 0 B/s
iteration_duration...: avg=0s min=0s med=0s max=0s p(90)=0s p(95)=0s
iterations...........: 1 499.950005/s
  { tag:xyz }........: 0 0/s
two..................: 42 20997.90021/s
```

When we would have expected it to produce:

```
one..................: 0 0/s
  { tag:xyz }........: 0 0/s
two..................: 42
```

This issue has been addressed in [#2519](https://github.com/grafana/k6/pull/2519), and k6 `v0.38.2` now displays sub-metrics under their actual parents, even when they have received no samples.


Special thanks to @efdknittlfrank, who reported and helped us track down the issue.